#
# Copyright (c) 2008-2019 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.annotation import IAttributeAnnotatable
from zope.interface import Interface
from zope.schema import Datetime, Int, Text, TextLine

from pyams_content.shared.form.interfaces import IFormHandlerInfo
from pyams_i18n.schema import I18nHTMLField, I18nTextLineField
from pyams_utils.schema import JSONDictField, MailAddressField, MailAddressesListField


__docformat__ = 'restructuredtext'

from onf_website import _


CONTACT_FORM_HANDLER_ANNOTATIONS_KEY = 'onf_website.contact.form.handler'


class IContactFormHandlerInfo(IFormHandlerInfo):
    """Contact form handler info"""

    service_name = I18nTextLineField(title=_("Service name"),
                                     description=_("This name will be used to prefix all email "
                                                   "messages sent by this contact form"),
                                     required=False)

    crm_source = TextLine(title=_("CRM source"),
                          description=_("If this contact form is supposed to match a CRM source, "
                                        "please enter it here"),
                          required=False)

    source_address = MailAddressField(title=_("Source address"),
                                      description=_("Mail address from which form data is sent"),
                                      required=False)

    source_name = TextLine(title=_("Source name"),
                           description=_("Name of mail data sender"),
                           required=False)

    target_address = MailAddressesListField(title=_("Recipient address"),
                                            description=_("Mail addresses to which form data is "
                                                          "systematically sent"),
                                            required=False)

    target_name = TextLine(title=_("Recipient name"),
                           description=_("Name of data recipient"),
                           required=False)

    notification_message = I18nHTMLField(title=_("Notification message"),
                                         description=_("This message will be sent to contacts "
                                                       "matching given theme and geographic area; "
                                                       "you can include form fields values by "
                                                       "including their name, enclosed in "
                                                       "{brackets}; if you don't provide any "
                                                       "template, message will be filled only with "
                                                       "the raw data entered into this form"),
                                         required=False)

    confirm_message = I18nHTMLField(title=_("Confirmation message"),
                                    description=_("If an email address is provided in the form, "
                                                  "this message will be returned to the contact; "
                                                  "you can include form fields values by including "
                                                  "their name, enclosed in {brackets}"),
                                    required=False)

    redirection_message = I18nHTMLField(title=_("Redirection message"),
                                        description=_("If the assignment or contact matching "
                                                      "internet user location has an associated "
                                                      "URL, no email is sent but the user is "
                                                      "redirected to a result page containing "
                                                      "links to given URLs; you can customize the "
                                                      "message content, the {links} text will be "
                                                      "replaced by the dynamically generated "
                                                      "links"),
                                        required=False)


class IContactFormHandlerTarget(IAttributeAnnotatable):
    """Contact form handler target marker interface"""


class ILeadLog(Interface):
    """Lead log interface"""

    oid = TextLine(title=_("Reference"))

    form_version = Int(title=_("Form version"))

    submit_date = Datetime(title=_("Submit date"))

    submit_email = TextLine(title=_("Contact email"))

    rgpd_consent = Text(title=_("RGPD consent"))

    submit_data = JSONDictField(title=_("Submit data"))

    contacts = Text(title=_("Solicited contacts"))
