#
# Copyright (c) 2015-2023 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from elasticsearch_dsl import Q

from onf_website.reference.forest.schema import ForestsListField
from pyams_content.shared.common import IBaseSharedTool
from pyams_content.shared.common.zmi.search import SharedToolAdvancedSearchResultsView, SharedToolAdvancedSearchView
from pyams_content_es.shared.zmi.search import EsSharedToolAdvancedSearchForm, \
    EsSharedToolAdvancedSearchFormSearchAdapter, IEsSharedToolAdvancedSearchFields
from pyams_form.interfaces.form import ISearchFormFactory
from pyams_skin.interfaces import IContentSearch
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config


__docformat__ = 'restructuredtext'

from onf_website import _


class IONFSharedToolAdvancedSearchFields(IEsSharedToolAdvancedSearchFields):
    """ONF shared tool advanced search fields"""

    forest_ids = ForestsListField(title=_("Location forests"),
                                  required=False)


@template_config(template='templates/advanced-search.pt',
                 layer=IPyAMSLayer)
class ONFSharedToolAdvancedSearchForm(EsSharedToolAdvancedSearchForm):
    """ONF shared tool advanced search form"""

    fields_interface = IONFSharedToolAdvancedSearchFields


@adapter_config(context=(IBaseSharedTool, IPyAMSLayer, SharedToolAdvancedSearchView),
                provides=ISearchFormFactory)
@adapter_config(context=(IBaseSharedTool, IPyAMSLayer, SharedToolAdvancedSearchResultsView),
                provides=ISearchFormFactory)
def shared_tool_advanced_search_form_factory(context, request, view):
    """ONF Elasticsearch advanced search form factory"""
    return ONFSharedToolAdvancedSearchForm(context, request)


@adapter_config(context=(IBaseSharedTool, IPyAMSLayer, ONFSharedToolAdvancedSearchForm),
                provides=IContentSearch)
class ONFSharedToolAdvancedSearchFormSearchAdapter(EsSharedToolAdvancedSearchFormSearchAdapter):
    """ONF Shared tool advanced search form search adapter"""

    def get_params(self, data):
        params = super().get_params(data)
        if data.get('forest_ids'):
            params &= Q('terms', location__forests=data['forest_ids'])
        return params
