#
# Copyright (c) 2015-2023 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'

from z3c.form.field import Fields

from onf_website.shared.common.skin.interfaces import IExperienceRootHeaderPortletRendererSettings
from pyams_form.group import NamedWidgetsGroup
from pyams_form.interfaces.form import IFormManager
from pyams_form.manager import DialogEditFormFormManager
from pyams_portal.zmi.portlet import PortletRendererPropertiesEditForm
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import adapter_config
from pyams_zmi.form import AdminDialogEditForm

from onf_website import _


@adapter_config(required=(IExperienceRootHeaderPortletRendererSettings, IPyAMSLayer,
                          PortletRendererPropertiesEditForm),
                provides=IFormManager)
class ExperienceRootHeaderPortletRendererSettingsFormManager(DialogEditFormFormManager):
    """Experience root header portlet renderer settings edit form manager"""

    def getFields(self):
        return Fields(IExperienceRootHeaderPortletRendererSettings)

    def updateGroups(self):
        view = self.view
        view.add_group(NamedWidgetsGroup(view, 'illustration', view.widgets,
                                         ('images_selection_mode', 'expengine', 'heading_text',
                                          'heading_base_color', 'heading_highlight_color'),
                                         legend=_("Illustration"),
                                         css_class='inner',
                                         switch=False))
        view.add_group(NamedWidgetsGroup(view, 'animation', view.widgets,
                                         ('highlight_reference', 'thumbnail_display', 'background_selection_mode',
                                          'thumbnail_text', 'thumbnail_bg_color', 'thumbnail_text_color',
                                          'thumbnail_alt_title', 'thumbnail_alt_header', 'thumbnail_mobile_header'),
                                         legend=_("Animation"),
                                         css_class='inner',
                                         switch=False))
        AdminDialogEditForm.updateGroups(view)
