#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from onf_website.skin.public.interfaces import IBodyClass
from onf_website.skin.public.layer import IONFBaseLayer
from pyams_content.shared.common import IWfSharedContent
from pyams_utils.adapter import adapter_config


@adapter_config(context=(IWfSharedContent, IONFBaseLayer), provides=IBodyClass)
def shared_content_body_class_adapter(context, request):
    return 'body--{}'.format(context.content_type)
