#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from onf_website.component.location.interfaces import ILocationInfo
from onf_website.shared.common.interfaces import IManagerRestrictionInfo
from pyams_content.interfaces import MANAGE_CONTENT_PERMISSION
from pyams_content.shared.common.security import SharedToolManagerRestrictionInfo as \
    SharedToolManagerRestrictionInfoBase

# import packages
from zope.interface import implementer
from zope.schema.fieldproperty import FieldProperty


@implementer(IManagerRestrictionInfo)
class SharedToolManagerRestrictionInfo(SharedToolManagerRestrictionInfoBase):
    """Shared tool manager restrictions"""

    restriction_interface = IManagerRestrictionInfo

    countries = FieldProperty(IManagerRestrictionInfo['countries'])
    departments = FieldProperty(IManagerRestrictionInfo['departments'])
    structures = FieldProperty(IManagerRestrictionInfo['structures'])
    forests = FieldProperty(IManagerRestrictionInfo['forests'])

    def check_access(self, context, permission=MANAGE_CONTENT_PERMISSION, request=None):
        check = super(SharedToolManagerRestrictionInfo, self).check_access(context, permission, request)
        if check:
            return check
        location = ILocationInfo(context, None)
        if location is not None:
            if set(location.countries or set()) & set(self.countries or set()):
                return True
            if set(location.departments or set()) & set(self.departments or set()):
                return True
            if set(location.structures or set()) & set(self.structures or set()):
                return True
            if set(location.forests or set()) & set(self.forests or set()):
                return True
        return False
