#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import implementer, provider
from zope.schema.fieldproperty import FieldProperty

from onf_website.component.hearing import IHearingTarget
from onf_website.component.location import ILocationTarget
from onf_website.shared.casestudy.interfaces import CASE_STUDY_CONTENT_NAME, CASE_STUDY_CONTENT_TYPE, ICaseStudy, \
    IWfCaseStudy, IWfCaseStudyFactory
from pyams_content.component.illustration.interfaces import IIllustrationTarget, ILinkIllustrationTarget
from pyams_content.component.paragraph.interfaces import IParagraphContainerTarget
from pyams_content.component.theme.interfaces import ITagsTarget, IThemesTarget
from pyams_content.features.preview.interfaces import IPreviewTarget
from pyams_content.features.review.interfaces import IReviewTarget
from pyams_content.shared.common import SharedContent, WfSharedContent, register_content_type
from pyams_content.shared.common.interfaces import IWfSharedContentFactory
from pyams_sequence.reference import get_reference_target
from pyams_utils.adapter import adapter_config


@implementer(IWfCaseStudy, IIllustrationTarget, ILinkIllustrationTarget, IParagraphContainerTarget,
             ILocationTarget, IHearingTarget, ITagsTarget, IThemesTarget, IPreviewTarget, IReviewTarget)
class WfCaseStudy(WfSharedContent):
    """Base case study class"""

    content_type = CASE_STUDY_CONTENT_TYPE
    content_name = CASE_STUDY_CONTENT_NAME

    references = FieldProperty(IWfCaseStudy['references'])
    logos = FieldProperty(IWfCaseStudy['logos'])

    def get_logos(self, state=None, with_reference=False, request=None):
        for reference in self.logos or ():
            if with_reference:
                yield reference, get_reference_target(reference, state)
            else:
                yield get_reference_target(reference, state)


register_content_type(WfCaseStudy)


@provider(IWfCaseStudyFactory)
@implementer(ICaseStudy)
class CaseStudy(SharedContent):
    """Workflow managed case study class"""


@adapter_config(context=IWfCaseStudyFactory, provides=IWfSharedContentFactory)
def case_study_content_factory(context):
    return WfCaseStudy
