#
# Copyright (c) 2015-2023 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from elasticsearch_dsl import Q

from onf_website.reference.forest.schema import ForestsListField
from pyams_content.root import ISiteRoot
from pyams_content.root.zmi.search import SiteRootAdvancedSearchResultsView, SiteRootAdvancedSearchView
from pyams_content_es.root.zmi.search import EsSiteRootAdvancedSearchForm, EsSiteRootAdvancedSearchFormSearchAdapter, \
    IEsSiteRootAdvancedSearchFields
from pyams_form.interfaces.form import ISearchFormFactory
from pyams_skin.interfaces import IContentSearch
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config

__docformat__ = 'restructuredtext'

from onf_website import _


class IONFSiteRootAdvancedSearchFields(IEsSiteRootAdvancedSearchFields):
    """ONF site root advanced search fields"""

    forest_ids = ForestsListField(title=_("Location forests"),
                                  required=False)


@template_config(template='templates/advanced-search.pt',
                 layer=IPyAMSLayer)
class ONFSiteRootAdvancedSearchForm(EsSiteRootAdvancedSearchForm):
    """ONF site root advanced search form"""

    fields_interface = IONFSiteRootAdvancedSearchFields


@adapter_config(context=(ISiteRoot, IPyAMSLayer, SiteRootAdvancedSearchView),
                provides=ISearchFormFactory)
@adapter_config(context=(ISiteRoot, IPyAMSLayer, SiteRootAdvancedSearchResultsView),
                provides=ISearchFormFactory)
def site_root_advanced_search_form_factory(context, request, view):
    """ONF site root advanced search form factory"""
    return ONFSiteRootAdvancedSearchForm(context, request)


@adapter_config(context=(ISiteRoot, IPyAMSLayer, ONFSiteRootAdvancedSearchForm),
                provides=IContentSearch)
class ONFSiteRootAdvancedSearchFormSearchAdapter(EsSiteRootAdvancedSearchFormSearchAdapter):
    """ONF site root advanced search form search adapter"""

    def get_params(self, data):
        params = super().get_params(data)
        if data.get('forest_ids'):
            params &= Q('terms', location__forests=data['forest_ids'])
        return params
