#
# Copyright (c) 2015-2023 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from z3c.form.field import Fields

from onf_website.shared.site import ISiteManagerUniverseInfo
from pyams_content.root.interfaces import ISiteRoot
from pyams_form.interfaces.form import IInnerSubForm
from pyams_utils.adapter import adapter_config
from pyams_zmi.form import InnerAdminEditForm
from pyams_zmi.layer import IAdminLayer
from pyams_zmi.zmi.site import PropertiesEditForm

__docformat__ = 'restructuredtext'

from onf_website import _


@adapter_config(name='universe',
                required=(ISiteRoot, IAdminLayer, PropertiesEditForm),
                provides=IInnerSubForm)
class SiteRootUniverseEditForm(InnerAdminEditForm):
    """Site root universe edit subform"""
    
    prefix = 'universe_form.'
    
    legend = _("Universe")
    
    fields = Fields(ISiteManagerUniverseInfo)
    
    weight = 2
