#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Attribute

from pyams_content.root.interfaces import ISiteRootToolsConfiguration as ISiteRootToolsConfigurationBase


class ISiteRootToolsConfiguration(ISiteRootToolsConfigurationBase):
    """Site root tools configuration interface"""

    country_table_name = Attribute("Countries table name")
    region_table_name = Attribute("Regions table name")
    department_table_name = Attribute("Departments table name")
    territory_table_name = Attribute("Territories table name")
    agency_table_name = Attribute("Agencies table name")
    unit_table_name = Attribute("Territorial units table name")
    target_table_name = Attribute("Targets table name")

    resources_tool_name = Attribute("Resources tool name")
    reports_tool_name = Attribute("Reports tool name")
    interviews_tool_name = Attribute("Interviews tool name")
    expengines_tool_name = Attribute("Experiential engines tool name")
    longreads_tool_name = Attribute("Long-reads tool name")
    activities_tool_name = Attribute("Activities tool name")
    casestudies_tool_name = Attribute("Cases studies tool name")
    services_tool_name = Attribute("Service deliveries tool name")
    press_tool_name = Attribute("Press folders tool name")
    contacts_tool_name = Attribute("Contacts tool name")
    hunting_tool_name = Attribute("Hunting calendars tool name")
    forests_tool_name = Attribute("Forests tool name")
    reserves_tool_name = Attribute("Natural reserves tool name")
    furniture_tool_name = Attribute("Furniture tool name")
