# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from collections import OrderedDict

from zope.schema import Choice
from zope.schema.vocabulary import SimpleTerm, SimpleVocabulary

from pyams_portal.interfaces import IPortletRendererSettings

__docformat__ = 'restructuredtext'

from onf_website import _


NEARME_MAP_TARGET = 'map-view'
NEARME_LIST_TARGET = 'list-view'

NEARME_TARGET_MODES = OrderedDict((
    (NEARME_MAP_TARGET, _("'Near me' mode")),
    (NEARME_LIST_TARGET, _("'In region' mode'"))
))

NEARME_TARGET_MODES_VOCABULARY = SimpleVocabulary([
    SimpleTerm(k, title=v)
    for k, v in NEARME_TARGET_MODES.items()
])


class INearmePortletBaseRendererSettings(IPortletRendererSettings):
    """Near me portlet base renderer settings"""
    
    nearme_mode = Choice(title=_("Universe display mode"),
                         description=_("Mode in which target universe will be displayed"),
                         vocabulary=NEARME_TARGET_MODES_VOCABULARY,
                         default=NEARME_MAP_TARGET)


class INearmePortletLinkRendererSettings(INearmePortletBaseRendererSettings):
    """Nearme portlet link renderer settings interface"""


class INearmePortletPopupRendererSettings(INearmePortletBaseRendererSettings):
    """Nearme portlet popup renderer settings interface"""
