#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.schema.fieldproperty import FieldProperty

from onf_website.reference.universe.portlet.interfaces import INearmePortletSettings
from pyams_portal.portlet import Portlet, PortletSettings, portlet_config
from pyams_utils.factory import factory_config
from pyams_utils.interfaces import VIEW_PERMISSION

__docformat__ = 'restructuredtext'

from onf_website import _


NEARME_PORTLET_NAME = 'pyams_content.portlet.nearme'


@factory_config(INearmePortletSettings)
class NearmePortletSettings(PortletSettings):
    """Near me portlet settings"""
    
    title = FieldProperty(INearmePortletSettings['title'])


@portlet_config(permission=VIEW_PERMISSION)
class NearmePortet(Portlet):
    """Toolbox portlet"""

    name = NEARME_PORTLET_NAME

    label = _("ONF: Near me link")
    toolbar_css_class = 'fa fa-fw fa-2x fa-map-marker'

    settings_factory = INearmePortletSettings
