#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.container.constraints import containers
from zope.schema import Bool, Choice, Int

from pyams_content.reference.interfaces import IReferenceInfo, IReferenceTable
from pyams_content.shared.view import WfView
from pyams_i18n.schema import I18nTextField, I18nTextLineField
from pyams_portal.interfaces import IPortalContext, PORTAL_TEMPLATES_VOCABULARY
from pyams_sequence.schema import InternalReferenceField, InternalReferencesListField

__docformat__ = 'restructuredtext'

from onf_website import _


class IUniverse(IReferenceInfo, IPortalContext):
    """Universe interface"""

    containers('.IUniverseTable')

    visible = Bool(title=_("Visible universe?"),
                   description=_("Set to 'yes' to show this universe"),
                   required=True,
                   default=False)

    title = I18nTextLineField(title=_("Title"),
                              description=_("Title displayed above the universe dropdown menu"),
                              required=True)

    description = I18nTextField(title=_("Description"),
                                description=_("Text description or detailed information"),
                                required=False)

    skin = Choice(title=_("Graphic theme"),
                  description=_("This theme will be used to handle graphic design (colors and images)"),
                  vocabulary='PyAMS user skins',
                  required=False)

    map_template = Choice(title=_("Map template"),
                          description=_("Template used to display map results"),
                          vocabulary=PORTAL_TEMPLATES_VOCABULARY)

    map_views = InternalReferencesListField(title=_("Selected map views"),
                                            description=_("Reference to the view(s) from which items are extracted; "
                                                          "you can combine several views together and specify in which "
                                                          "order they should be mixed"),
                                            content_type=WfView.content_type,
                                            required=False)

    def get_map_views(self):
        """Get iterator over selected map views"""

    map_limit = Int(title=_("Results map count limit"),
                    description=_("Maximum number of results that the component may extract from merged views"),
                    required=False)

    def get_map_items(self):
        """Get iterator over map items returned by selected views, using selected merger"""

    list_template = Choice(title=_("List template"),
                           description=_("Template used to display list results"),
                           vocabulary=PORTAL_TEMPLATES_VOCABULARY)

    list_views = InternalReferencesListField(title=_("Selected list views"),
                                             description=_("Reference to the view(s) from which items are extracted; "
                                                           "you can combine several views together and specify in which "
                                                           "order they should be mixed"),
                                             content_type=WfView.content_type,
                                             required=False)

    def get_list_views(self):
        """Get iterator over selected list views"""

    list_limit = Int(title=_("Results list count limit"),
                     description=_("Maximum number of results that the component may extract from merged views"),
                     required=False)

    def get_list_items(self):
        """Get iterator over list items returned by selected views, using selected merger"""

    contact_target = InternalReferenceField(title=_("Contact link target"),
                                            description=_("Internal content displaying contact information"),
                                            required=False)


class IUniverseTable(IReferenceTable):
    """Interface for the Universe table."""

    dropdown_menu_title = I18nTextLineField(title=_("Dropdown menu title"),
                                            description=_("Label positioned in the universe dropdown menu"),
                                            required=False)

    inactive_info_title = I18nTextLineField(title=_("Inactive mode information title"),
                                            description=_("Title for inactive info"),
                                            required=False)

    inactive_info_text = I18nTextField(title=_("Inactive mode information text"),
                                       description=_("Text for inactive info"),
                                       required=False)

    online_help_title = I18nTextLineField(title=_("Online help block title"),
                                          description=_("Title for online help"),
                                          required=False)

    online_help_text = I18nTextField(title=_("Online help block text"),
                                     description=_("Text for online help"),
                                     required=False)

    def get_visible_items(self):
        """Get iterator over visible items"""
