#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


from zope.interface import implementer
from zope.schema import List, TextLine
from zope.schema.interfaces import ITextLine


class IPlanningField(ITextLine):
    """Planning field interface"""


@implementer(IPlanningField)
class PlanningField(TextLine):
    """Planning field"""


class IPlanningsListField(ITextLine):
    """Plannings list field interface"""


@implementer(IPlanningsListField)
class PlanningsListField(List):
    """Plannings list field"""

    def __init__(self, value_type=None, unique=False, *args, **kwargs):
        super().__init__(value_type=TextLine(), unique=True, *args, **kwargs)
