#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


from z3c.form.interfaces import IWidget
from zope.schema import TextLine


class IStructureWidget(IWidget):
    """Single structure selection widget"""

    structure_type = TextLine(title="Structure type",
                              required=False)

    category_code = TextLine(title="Category code",
                             required=False)


class IStructuresListWidget(IWidget):
    """Structures list selection widget"""

    structure_type = TextLine(title="Structure type",
                              required=False)

    category_code = TextLine(title="Category code",
                             required=False)
