#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from onf_website.reference.location.interfaces.country import ICountryTable, ICountry
from pyams_content.interfaces import MANAGE_SITE_ROOT_PERMISSION
from pyams_skin.interfaces.viewlet import IWidgetTitleViewletManager
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION
from pyams_zmi.layer import IAdminLayer

# import packages
from onf_website.reference.location.country import Country
from pyams_content.reference.zmi import ReferenceInfoAJAXEditForm
from pyams_content.reference.zmi.table import ReferenceTableContentsTable
from pyams_form.form import AJAXAddForm, ajax_config
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.viewlet.toolbar import ToolbarAction
from pyams_viewlet.viewlet import viewlet_config
from pyams_zmi.form import AdminDialogAddForm, AdminDialogEditForm
from z3c.form import field

from onf_website import _


@viewlet_config(name='add-country.action', context=ICountryTable, layer=IAdminLayer,
                manager=IWidgetTitleViewletManager, view=ReferenceTableContentsTable,
                permission=MANAGE_SITE_ROOT_PERMISSION)
class CountryAddAction(ToolbarAction):
    """Country add action"""

    label = _("Add country")

    url = 'add-country.html'
    modal_target = True


@pagelet_config(name='add-country.html', context=ICountryTable, layer=IPyAMSLayer,
                permission=MANAGE_SITE_ROOT_PERMISSION)
@ajax_config(name='add-country.json', context=ICountryTable, layer=IPyAMSLayer, base=AJAXAddForm)
class CountryAddForm(AdminDialogAddForm):
    """Country add form"""

    legend = _("Adding new country")

    fields = field.Fields(ICountry).omit('__parent__')
    edit_permission = MANAGE_SITE_ROOT_PERMISSION

    def create(self, data):
        return Country()

    def add(self, object):
        self.context[object.__name__] = object

    def nextURL(self):
        return 'contents.html'


@pagelet_config(name='properties.html', context=ICountry, layer=IPyAMSLayer, permission=VIEW_SYSTEM_PERMISSION)
@ajax_config(name='properties.json', context=ICountry, layer=IPyAMSLayer, base=ReferenceInfoAJAXEditForm)
class CountryEditForm(AdminDialogEditForm):
    """Country edit form"""

    prefix = 'country_properties.'

    legend = _("Edit country properties")

    fields = field.Fields(ICountry).omit('__parent__', '__name__')
    edit_permission = MANAGE_SITE_ROOT_PERMISSION
