#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from onf_website.reference.location.interfaces.agency import IAgencyTable, IAgency
from pyams_content.interfaces import MANAGE_SITE_ROOT_PERMISSION
from pyams_skin.interfaces.viewlet import IWidgetTitleViewletManager
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION
from pyams_zmi.layer import IAdminLayer

# import packages
from onf_website.reference.location.agency import Agency
from pyams_content.reference.zmi import ReferenceInfoAJAXEditForm
from pyams_content.reference.zmi.table import ReferenceTableContentsTable
from pyams_form.form import AJAXAddForm, ajax_config
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.viewlet.toolbar import ToolbarAction
from pyams_viewlet.viewlet import viewlet_config
from pyams_zmi.form import AdminDialogAddForm, AdminDialogEditForm
from z3c.form import field

from onf_website import _


@viewlet_config(name='add-agency.action', context=IAgencyTable, layer=IAdminLayer,
                manager=IWidgetTitleViewletManager, view=ReferenceTableContentsTable,
                permission=MANAGE_SITE_ROOT_PERMISSION)
class AgencyAddAction(ToolbarAction):
    """Agency add action"""

    label = _("Add agency")

    url = 'add-agency.html'
    modal_target = True


@pagelet_config(name='add-agency.html', context=IAgencyTable, layer=IPyAMSLayer, permission=MANAGE_SITE_ROOT_PERMISSION)
@ajax_config(name='add-agency.json', context=IAgencyTable, layer=IPyAMSLayer, base=AJAXAddForm)
class AgencyAddForm(AdminDialogAddForm):
    """Agency add form"""

    legend = _("Adding new agency")

    fields = field.Fields(IAgency).omit('__parent__')
    edit_permission = MANAGE_SITE_ROOT_PERMISSION

    def create(self, data):
        return Agency()

    def add(self, object):
        self.context[object.__name__] = object

    def nextURL(self):
        return 'contents.html'


@pagelet_config(name='properties.html', context=IAgency, layer=IPyAMSLayer, permission=VIEW_SYSTEM_PERMISSION)
@ajax_config(name='properties.json', context=IAgency, layer=IPyAMSLayer, base=ReferenceInfoAJAXEditForm)
class AgencyEditForm(AdminDialogEditForm):
    """Agency edit form"""

    prefix = 'agency_properties.'

    legend = _("Edit agency properties")

    fields = field.Fields(IAgency).omit('__parent__', '__name__')
    edit_permission = MANAGE_SITE_ROOT_PERMISSION
