#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.reference.interfaces import IReferenceTable
from onf_website.reference.location.interfaces import IBaseLocationInfo

# import packages
from pyams_content.shared.logo import WfLogo
from pyams_sequence.schema import InternalReferenceField
from zope.container.constraints import contains, containers
from zope.schema import TextLine, List, Choice

from onf_website import _


class IDepartment(IBaseLocationInfo):
    """Department interface"""

    containers('.IDepartmentTable')

    insee_code = TextLine(title=_("INSEE code"),
                          required=False)

    logo = InternalReferenceField(title=_("Logo"),
                                  description=_("Logo associated with this department"),
                                  content_type=WfLogo.content_type,
                                  required=False)

    def get_logo(self):
        """Get reference to selected logo"""

    region = Choice(title=_("Region"),
                    vocabulary='ONF regions',
                    required=False)

    neighbors = List(title=_("Neighbors departments"),
                     value_type=Choice(vocabulary='ONF departments'),
                     required=False)


class IDepartmentTable(IReferenceTable):
    """Departments table"""

    contains(IDepartment)
