#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from onf_website.reference.insee.model import Departement as DepartementInsee, PARENT_SESSION, Region as RegionInsee
from onf_website.reference.location.agency import Agency
from onf_website.reference.location.department import Department
from onf_website.reference.location.interfaces.agency import IAgencyTable
from onf_website.reference.location.interfaces.department import IDepartmentTable
from onf_website.reference.location.interfaces.region import IRegionTable
from onf_website.reference.location.interfaces.territory import ITerritoryTable
from onf_website.reference.location.interfaces.unit import IUnitTable
from onf_website.reference.location.region import Region
from onf_website.reference.location.territory import Territory
from onf_website.reference.location.unit import Unit
from onf_website.reference.orga.model import Structure
from pyams_alchemy.engine import get_user_session
from pyams_utils.registry import query_utility


def init_locations():
    """Initialize locations from database"""
    territories = query_utility(ITerritoryTable)
    agencies = query_utility(IAgencyTable)
    units = query_utility(IUnitTable)
    for structure in Structure.find(''):
        if structure.categorie in ('DT', 'DR'):
            if structure.code_sign not in territories:
                record = Territory()
                record.title = {'fr': structure.libelle_long}
                record.short_name = {'fr': structure.libelle}
                record.internal_code = structure.code_sign
                territories[record.internal_code] = record
        elif structure.categorie == 'AGTERR':
            if structure.code_sign not in agencies:
                record = Agency()
                record.title = {'fr': structure.libelle_long}
                record.short_name = {'fr': structure.libelle}
                record.internal_code = structure.code_sign
                agencies[record.internal_code] = record
        elif structure.categorie == 'UT':
            if structure.code_sign not in units:
                record = Unit()
                record.title = {'fr': structure.libelle_long}
                record.short_name = {'fr': structure.libelle}
                record.internal_code = structure.code_sign
                units[record.internal_code] = record

    session = get_user_session(PARENT_SESSION)
    regions = query_utility(IRegionTable)
    for reg in session.query(RegionInsee):
        if reg.region not in regions:
            region = Region()
            region.title = {'fr': reg.nccenr}
            region.short_name = {'fr': reg.nccenr}
            region.insee_code = reg.region
            regions[region.insee_code] = region

    departments = query_utility(IDepartmentTable)
    for dept in session.query(DepartementInsee):
        if dept.dep not in departments:
            departement = Department()
            departement.title = {'fr': dept.nccenr}
            departement.short_name = {'fr': dept.nccenr}
            departement.insee_code = dept.dep
            departement.region = regions.get(dept.region)
            departments[departement.insee_code] = departement
