#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import implementer
from zope.schema import List, TextLine
from zope.schema.interfaces import ITextLine


__docformat__ = 'restructuredtext'


class IDepartmentField(ITextLine):
    """Department field interface"""


@implementer(IDepartmentField)
class DepartmentField(TextLine):
    """Department field"""


class IDepartmentsListField(ITextLine):
    """Departments list field interface"""


@implementer(IDepartmentsListField)
class DepartmentsListField(List):
    """Departments list field"""

    def __init__(self, value_type=None, unique=False, **kwargs):
        super(DepartmentsListField, self).__init__(value_type=TextLine(),
                                                   unique=True,
                                                   **kwargs)


class ICommuneField(ITextLine):
    """Commune field interface"""


@implementer(ICommuneField)
class CommuneField(TextLine):
    """Commune field"""


class ICommunesListField(ITextLine):
    """Communes list field interface"""


@implementer(ICommunesListField)
class CommunesListField(List):
    """Communes list field"""

    def __init__(self, value_type=None, unique=False, **kwargs):
        super(CommunesListField, self).__init__(value_type=TextLine(),
                                                unique=True,
                                                **kwargs)
