#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from colander import MappingSchema, SchemaNode, String, drop

from pyams_utils.rest import BaseResponseSchema


class InseeQuerySchema(BaseResponseSchema) :
    """Insee query"""


class InseeGetterRequest(MappingSchema):
    """Insee getter request"""
    querystring = InseeQuerySchema()


class InseeResult(MappingSchema) :
    """Base Insee Result"""
    insee = SchemaNode(String(),
                       description="Insee's code",
                       missing=drop)
    artmaj = SchemaNode(String(),
                        description="Commune's artmaj",
                        missing=drop)
    label = SchemaNode(String(),
                       description="Commune's Label",
                       missing=drop)


class InseeQueryResponse(BaseResponseSchema):
    """Insee Commune response schema"""
    commune = InseeResult(description="Insee commune info")


class InseeGetterResponse(MappingSchema):
    """Insee Commune getter response"""
    body = InseeQueryResponse()