#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""ONF_website module

"""

from z3c.form.field import Fields
from zope.interface import implementer

from onf_website.reference.forest import IForestTable
from onf_website.reference.forest.zmi.widget import ForestTableDisplaysSelectWidgetFactory
from pyams_content.interfaces import MANAGE_SITE_ROOT_PERMISSION
from pyams_content.reference.zmi.table import ReferenceTablePropertiesMenu
from pyams_form.form import ajax_config
from pyams_form.group import NamedWidgetsGroup
from pyams_form.interfaces.form import IInnerSubForm, IWidgetForm
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.interfaces import IInnerPage
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import adapter_config
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION
from pyams_viewlet.viewlet import viewlet_config
from pyams_zmi.form import AdminEditForm, InnerAdminEditForm
from pyams_zmi.interfaces.menu import IPropertiesMenu
from pyams_zmi.layer import IAdminLayer

__docformat__ = 'restructuredtext'

from onf_website import _


@viewlet_config(name='properties.menu',
                context=IForestTable, layer=IAdminLayer,
                manager=IPropertiesMenu, weight=10,
                permission=VIEW_SYSTEM_PERMISSION)
class ForestTablePropertiesMenu(ReferenceTablePropertiesMenu):
    """Forest table properties menu"""

    url = '#properties.html'
    modal_target = False


@pagelet_config(name='properties.html',
                context=IForestTable, layer=IPyAMSLayer,
                permission=VIEW_SYSTEM_PERMISSION)
@ajax_config(name='properties.json',
             context=IForestTable, layer=IPyAMSLayer)
@implementer(IWidgetForm, IInnerPage)
class ForestTablePropertiesEditForm(AdminEditForm):
    """Forest table properties edit form"""

    prefix = 'table_properties.'

    legend = _("Edit table properties")

    fields = Fields(IForestTable).select('title', 'short_name')
    edit_permission = MANAGE_SITE_ROOT_PERMISSION


@adapter_config(name='displays-settings',
                context=(IForestTable, IPyAMSLayer, ForestTablePropertiesEditForm),
                provides=IInnerSubForm)
class ForestTableForestsDisplaysSettingsEditForm(InnerAdminEditForm):
    """Forest table forests displays settings edit form"""

    prefix = 'display_properties.'

    legend = _("Forests display settings")
    fieldset_class = 'bordered no-x-margin margin-y-10'

    fields = Fields(IForestTable).select('forest_displays')
    fields['forest_displays'].widgetFactory = ForestTableDisplaysSelectWidgetFactory

    weight = 2

    def updateGroups(self):
        self.add_group(NamedWidgetsGroup(self, 'displays', self.widgets,
                                         ('forest_displays',),
                                         fieldset_class='inner bordered',
                                         switch=False))


@adapter_config(name='hunting-displays-settings',
                context=(IForestTable, IPyAMSLayer, ForestTablePropertiesEditForm),
                provides=IInnerSubForm)
class ForestTableHuntingDisplaysSettingsEditForm(InnerAdminEditForm):
    """Forest table hunting calendars displays settings edit form"""

    prefix = 'hunting_display_properties.'

    legend = _("Hunting calendars display settings")
    fieldset_class = 'bordered no-x-margin margin-y-10'

    fields = Fields(IForestTable).select('hunting_displays')
    fields['hunting_displays'].widgetFactory = ForestTableDisplaysSelectWidgetFactory

    weight = 2

    def updateGroups(self):
        self.add_group(NamedWidgetsGroup(self, 'displays', self.widgets,
                                         ('hunting_displays',),
                                         fieldset_class='inner bordered',
                                         switch=False))
