#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from zope.interface import Attribute
from zope.schema import Dict, Choice, Bool
from pyams_content.reference import IReferenceTable


__docformat__ = 'restructuredtext'

from onf_website import _


FOREST_OWNERS_CATEGORIES = 'onf_website.forest.owner.categories'


class IForestTable(IReferenceTable):
    """Forest table manager interface"""

    forest_displays = Dict(title=_("Forest displays"),
                           description=_("You can disable display of all forests for a specific "
                                         "owner category by just unchecking their label"),
                           key_type=Choice(vocabulary=FOREST_OWNERS_CATEGORIES),
                           value_type=Bool(required=True,
                                           default=True),
                           required=False)
    
    hunting_displays = Dict(title=_("Hunting calendar displays"),
                            description=_("You can disable display of all hunting calendars for "
                                          "a specific owner category by just unchecking their label"),
                            key_type=Choice(vocabulary=FOREST_OWNERS_CATEGORIES),
                            value_type=Bool(required=True,
                                            default=False),
                            required=False)

    visible_owners_ids = Attribute("Visible owners categories IDs")

    def get_published_forests(self):
        """Get list of published forests"""
        
    def get_published_hunting_calendars(self):
        """Get list of published hunting calendars forests"""
