#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Interface

from onf_website.reference.annuaire.portlet.interfaces import IDirectoryPortletSettings
from pyams_portal.interfaces import IPortalContext, IPortletRenderer
from pyams_portal.portlet import PortletRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config

__docformat__ = 'restructuredtext'

from onf_website import _


@adapter_config(context=(IPortalContext, IPyAMSLayer,Interface ,IDirectoryPortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/directory.pt', layer=IPyAMSLayer)
class DirectoryPortletDefaultRenderer(PortletRenderer):
    """Directory portlet renderer"""

    label = _("Default directory search engine renderer")
