#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from onf_website.reference.annuaire.portlet.interfaces import IDirectoryPortletSettings

from pyams_portal.portlet import Portlet, PortletSettings, portlet_config
from pyams_utils.factory import factory_config
from pyams_utils.interfaces import VIEW_PERMISSION

__docformat__ = 'restructuredtext'

from onf_website import _


DIRECTORY_PORTLET_NAME = 'onf_website.reference.annuaire.portlet.directory'


@factory_config(provided=IDirectoryPortletSettings)
class DirectoryPortletSettings(PortletSettings):
    """Directory portlet settings"""
    


@portlet_config(permission=VIEW_PERMISSION)
class DirectoryPortlet(Portlet):
    """Directory portlet"""

    name = DIRECTORY_PORTLET_NAME
    label = _("Communal directory")
    directory_css_class = 'fa fa-fw fa-2x fa-print'

    settings_factory = IDirectoryPortletSettings
