#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from onf_website.component.location import ILocationInfo, ILocationTarget
from pyams_i18n.interfaces import II18n
from pyams_utils.container import find_objects_providing
from pyams_utils.registry import get_local_registry, set_local_registry


def evolve(site):
    """Evolve 5: update GPS locations"""
    registry = get_local_registry()
    try:
        set_local_registry(site.getSiteManager())
        # Update location info
        for context in find_objects_providing(site, ILocationTarget):
            location = ILocationInfo(context, None)
            if location is not None:
                print("Upgrading location info of {}".format(
                    II18n(context).query_attribute('title')))
                location.update_gps_locations()
    finally:
        set_local_registry(registry)
