#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from z3c.form.field import Fields

from onf_website.features.zfiles import IZFilesClientInfo, IZFilesClientTarget
from pyams_content.interfaces import MANAGE_TOOL_PERMISSION
from pyams_form.form import ajax_config
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.layer import IPyAMSLayer
from pyams_skin.viewlet.menu import MenuItem
from pyams_viewlet.viewlet import viewlet_config
from pyams_zmi.form import AdminDialogEditForm
from pyams_zmi.interfaces.menu import IPropertiesMenu
from pyams_zmi.layer import IAdminLayer


__docformat__ = 'restructuredtext'

from onf_website import _


@viewlet_config(name='zfiles.menu',
                context=IZFilesClientTarget, layer=IAdminLayer,
                manager=IPropertiesMenu, weight=780,
                permission=MANAGE_TOOL_PERMISSION)
class ZFilesMenu(MenuItem):
    """ZFiles menu"""

    label = _("ZFiles client settings...")
    icon_class = 'fa-download'
    url = 'zfiles.html'
    modal_target = True


@pagelet_config(name='zfiles.html',
                context=IZFilesClientTarget,
                layer=IPyAMSLayer, permission=MANAGE_TOOL_PERMISSION)
@ajax_config(name='zfiles.json',
             context=IZFilesClientTarget, layer=IPyAMSLayer)
class ZFilesEditForm(AdminDialogEditForm):
    """Default paragraphs edit form"""

    prefix = 'zfiles.'

    legend = _("ZFiles client settings")

    fields = Fields(IZFilesClientInfo)
