#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from pyramid.httpexceptions import HTTPNotFound
from zope.interface import Interface
from zope.traversing.interfaces import ITraversable

from onf_website.features.zfiles.interfaces import IZFilesClientInfo
from pyams_skin.layer import IPyAMSUserLayer
from pyams_utils.adapter import ContextRequestAdapter, adapter_config


__docformat__ = 'restructuredtext'


@adapter_config(name='zfiles',
                context=(Interface, IPyAMSUserLayer),
                provides=ITraversable)
class ZFilesTraverser(ContextRequestAdapter):
    """ZFiles namespace traverser"""

    def traverse(self, oid, furtherpath=None):
        """++zfiles++ namespace traverser"""
        if not oid:
            raise HTTPNotFound()

        manager = self.context.get_zfiles_manager()
        if manager is None:
            raise HTTPNotFound()

        client_info = IZFilesClientInfo(manager, None)
        if client_info is None:
            raise HTTPNotFound()

        return client_info.get_document(oid)
