#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.annotation.interfaces import IAttributeAnnotatable
from zope.interface import Interface
from zope.schema import Bool, Password, TextLine, URI

from onf_website import _


class IZFilesClientInfo(Interface):
    """ZFiles client infos interface"""

    zfiles_url = URI(title=_("ZFiles URL"),
                     description=_("Base URL of ZFiles instance used to get "
                                   "remote documents"),
                     required=True)

    login = TextLine(title=_("Login"),
                     description=_("User login to connect to the ZFiles instance"),
                     required=True)

    password = Password(title=_("Password"),
                        description=_("User password to connect to the ZFiles instance"),
                        required=True)

    verify = Bool(title=_("Verify SSL"),
                  description=_("Verify SSL Certificate"),
                  required=True,
                  default=True)

    def get_target_url(self):
        """Get base ZFiles target URL"""

    def get_existing_docs(self, oids):
        """Get list of existing docs from provided OIDs"""

    def get_document(self, oid):
        """Get document content for given OID"""


class IZFilesClientTarget(IAttributeAnnotatable):
    """ZFiles client target interface"""
