# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from z3c.form import field

from onf_website.features.thesaurus import IThesaurusTermFilterInfo, IThesaurusTermFilterTarget
from pyams_content.reference.pictograms.zmi.widget import PictogramSelectFieldWidget
from pyams_form.form import ajax_config
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.layer import IPyAMSLayer
from pyams_thesaurus.interfaces import MANAGE_THESAURUS_CONTENT_PERMISSION
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION
from pyams_zmi.form import AdminDialogEditForm

__docformat__ = 'restructuredtext'

from onf_website import _


@pagelet_config(name='filter-properties.html',
                context=IThesaurusTermFilterTarget, layer=IPyAMSLayer,
                permission=VIEW_SYSTEM_PERMISSION)
@ajax_config(name='filter-properties.json',
             context=IThesaurusTermFilterTarget, layer=IPyAMSLayer)
class ThesaurusTermFilterPropertiesEditForm(AdminDialogEditForm):

    prefix = 'filter_form.'

    legend = _("Edit filter settings")
    dialog_class = 'modal-large'
    icon_css_class = 'fa fa-fw fa-filter'

    fields = field.Fields(IThesaurusTermFilterInfo)
    fields['associated_pictogram'].widgetFactory = PictogramSelectFieldWidget

    edit_permission = MANAGE_THESAURUS_CONTENT_PERMISSION

    def getContent(self):
        return IThesaurusTermFilterInfo(self.context)
