from persistent import Persistent
from zope.container.contained import Contained
from zope.schema.fieldproperty import FieldProperty

from onf_website.features.thesaurus.interfaces import IThesaurusTermFilterInfo, IThesaurusTermFilterTarget
from pyams_content.reference.pictograms import IPictogramTable
from pyams_thesaurus.interfaces.extension import IThesaurusTermExtension
from pyams_utils.adapter import adapter_config, get_annotation_adapter
from pyams_utils.factory import factory_config
from pyams_utils.registry import get_utility, utility_config

from onf_website import _


@factory_config(provided=IThesaurusTermFilterInfo)
class ThesaurusTermFilter(Persistent, Contained):
    """Persistent implementation of thesaurus term filters."""

    display_in_tags_list = FieldProperty(IThesaurusTermFilterInfo['display_in_tags_list'])
    display_in_facets_list = FieldProperty(IThesaurusTermFilterInfo['display_in_facets_list'])
    associated_pictogram = FieldProperty(IThesaurusTermFilterInfo['associated_pictogram'])

    def get_pictogram(self):
        if not self.associated_pictogram:
            return None
        table = get_utility(IPictogramTable)
        return table.get(self.associated_pictogram)
        

@adapter_config(context=IThesaurusTermFilterTarget,
                provides=IThesaurusTermFilterInfo)
def thesaurus_term_filter_factory(context):
    """Factory to adapt thesaurus term objects to filter settings"""
    return get_annotation_adapter(context, 'onf_website.thesaurus.term.filters', IThesaurusTermFilterInfo)


@utility_config(name='thesaurus_term_filters',
                provides=IThesaurusTermExtension)
class FilterThesaurusExtension:
    """Thesaurus filter extension"""

    label = _("Filters")
    weight = 30

    target_interface = IThesaurusTermFilterTarget
    target_view = "filter-properties.html"

    icon = '<i class="fa fa-fw fa-filter"></i>'
