#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""ONF_Website.features.tarteaucitron.zmi module

Management interface for TarteAuCitron configuration.
"""

__docformat__ = 'restructuredtext'

from z3c.form import field
from zope.interface import alsoProvides

from onf_website.features.tarteaucitron import ITarteAuCitronInfo
from pyams_form.form import ajax_config
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.layer import IPyAMSLayer
from pyams_skin.viewlet.menu import MenuItem
from pyams_utils.interfaces import MANAGE_SYSTEM_PERMISSION
from pyams_utils.interfaces.data import IObjectData
from pyams_utils.interfaces.site import ISiteRoot
from pyams_viewlet.viewlet import viewlet_config
from pyams_zmi.form import AdminDialogEditForm
from pyams_zmi.interfaces.menu import IPropertiesMenu
from pyams_zmi.layer import IAdminLayer

from onf_website import _


@viewlet_config(name='tarteaucitron.menu',
                context=ISiteRoot, layer=IAdminLayer,
                manager=IPropertiesMenu, weight=840,
                permission=MANAGE_SYSTEM_PERMISSION)
class TarteAuCitronPropertiesMenuItem(MenuItem):
    """TarteAuCitron properties menu"""

    label = _("TarteAuCitron settings...")
    icon_class = 'fa-hashtag'
    url = 'tarteaucitron-properties.html'
    modal_target = True


@pagelet_config(name='tarteaucitron-properties.html',
                context=ISiteRoot, layer=IPyAMSLayer,
                permission=MANAGE_SYSTEM_PERMISSION)
@ajax_config(name='tarteaucitron-properties.json',
             context=ISiteRoot, layer=IPyAMSLayer)
class TarteAuCitronPropertiesEditForm(AdminDialogEditForm):
    """TarteAuCitron properties edit form"""

    prefix = 'tarteaucitron_properties.'
    dialog_class = 'modal-max'

    legend = _("Update TarteAuCitron module properties")
    edit_permission = MANAGE_SYSTEM_PERMISSION

    fields = field.Fields(ITarteAuCitronInfo)

    def updateWidgets(self, prefix=None):
        super().updateWidgets(prefix)
        services = self.widgets.get('services')
        if services is not None:
            services.widget_css_class = 'input height-500 monospace text-editor'
            services.object_data = {
                'ams-editor-filename': 'services.js'
            }
            alsoProvides(services, IObjectData)
