#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""ONF_Website.features.tarteaucitron.interfaces module

"""

from zope.interface import Interface
from zope.schema import Bool, Choice, Text, TextLine

from pyams_sequence.schema import InternalReferenceField


__docformat__ = 'restructuredtext'

from onf_website import _


class ITarteAuCitronInfo(Interface):
    """TarteAuCitron information interface"""

    enabled = Bool(title=_("Enable module"),
                   description=_("Is TarteAuCitron module enabled?"),
                   required=True,
                   default=False)

    policy_target = InternalReferenceField(title=_("Privacy policy target"),
                                           description=_("Internal reference to privacy policy"),
                                           required=False)

    hashtag = TextLine(title=_("Panel hashtag"),
                       description=_("Open the panel with this hashtag"),
                       default='#tarteaucitron')

    cookie_name = TextLine(title=_("Cookie name"),
                           description=_("Name of the cookie used to store user choices"),
                           default='tarteaucitron')

    orientation = Choice(title=_("Orientation"),
                         description=_("Banner position"),
                         values=('top', 'bottom', 'middle'),
                         default='bottom')

    group_services = Bool(title=_("Group services"),
                          description=_("Check to group services by category"),
                          required=True,
                          default=False)

    show_alert_small = Bool(title=_("Show small alert"),
                            description=_("If 'yes', show the small banner on bottom right"),
                            required=True,
                            default=False)

    cookies_list = Bool(title=_("Show cookies list"),
                        description=_("If 'yes', show the used cookies list"),
                        required=True,
                        default=False)

    close_popup = Bool(title=_("Close popup"),
                       description=_("If 'yes', show a close button in popup"),
                       required=True,
                       default=False)

    show_icon = Bool(title=_("Show icon"),
                     description=_("Show cookie icon to manage cookies"),
                     required=True,
                     default=True)

    icon_position = Choice(title=_("Icon position"),
                           description=_("Position of cookies icon"),
                           values=('BottomRight', 'BottomLeft', 'TopRight', 'TopLeft'),
                           default='BottomRight')

    adblocker = Bool(title=_("Adblock warning"),
                     description=_("Show a warning when an adblock is detected"),
                     required=True,
                     default=False)

    deny_all = Bool(title=_("Deny all button"),
                    description=_("Show the \"Deny all\" button"),
                    required=True,
                    default=True)

    accept_all = Bool(title=_("Accept all button"),
                      description=_("Show the \"Accept all\" button"),
                      required=True,
                      default=True)

    mandatory = Bool(title=_("Mandatory info"),
                     description=_("If 'yes', show message about mandatory cookies"),
                     required=True,
                     default=True)

    high_privacy = Bool(title=_("Disabled auto consent"),
                        description=_("If 'no', automatic consent will be applied"),
                        required=True,
                        default=True)

    remove_credit = Bool(title=_("Remove credit link"),
                         description=_("If 'yes', credit link will be removed"),
                         required=True,
                         default=False)

    more_info = Bool(title=_("More info link"),
                     description=_("Show an additional link for more information"),
                     required=True,
                     default=True)

    more_info_link = InternalReferenceField(title=_("More info target"),
                                            description=_("If defined, this link will replace "
                                                          "the default information link"),
                                            required=False)

    services = Text(title=_("Services script"),
                    description=_("Javascript code of enabled services"),
                    required=False)



TARTEAUCITRON_ANNOTATION_KEY = 'onf_website.features.tarteaucitron'
