#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from persistent import Persistent
from zope.container.contained import Contained
from zope.interface import Interface
from zope.schema.fieldproperty import FieldProperty

from onf_website.features.share.skin.interfaces import IONFToolboxPortletRendererSettings
from onf_website.skin.public import aside_sticky
from onf_website.skin.public.layer import IONFBaseLayer
from pyams_content.features.share.portlet import IToolboxPortletSettings
from pyams_default_theme.features.share.portlet import ToolboxPortletDefaultRenderer
from pyams_i18n.interfaces import II18n
from pyams_portal.interfaces import IPortalContext, IPortletRenderer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.factory import factory_config

from onf_website import _


@factory_config(provided=IONFToolboxPortletRendererSettings)
class ONFToolboxPortletRendererSettings(Persistent, Contained):
    """Toolbox portlet default renderer settings"""

    button_title = FieldProperty(IONFToolboxPortletRendererSettings['button_title'])


@adapter_config(context=(IPortalContext, IONFBaseLayer, Interface, IToolboxPortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/toolbox.pt', layer=IONFBaseLayer)
class ONFToolboxPortletDefaultRenderer(ToolboxPortletDefaultRenderer):
    """Toolbox portlet default renderer"""

    settings_interface = IONFToolboxPortletRendererSettings

    @property
    def title(self):
        title = II18n(self.renderer_settings).query_attribute('button_title', request=self.request)
        if not title:
            title = self.request.localizer.translate(_("Share"))
        return title

    resources = (aside_sticky,)
