# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from z3c.form.browser.checkbox import SingleCheckBoxFieldWidget
from z3c.form.field import Fields
from zope.schema import getFieldsInOrder
from zope.schema.fieldproperty import FieldProperty

from onf_website.features.search.skin.interfaces.nearme import INearmeMapSearchResultsPortletRendererSettings
from pyams_form.group import NamedWidgetsGroup
from pyams_form.interfaces.form import IFormManager
from pyams_form.manager import DialogEditFormFormManager
from pyams_gis.interfaces.configuration import IMapConfiguration
from pyams_portal.zmi.portlet import PortletRendererPropertiesEditForm
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import adapter_config

__docformat__ = 'restructuredtext'

from onf_website import _


@adapter_config(required=(INearmeMapSearchResultsPortletRendererSettings, IPyAMSLayer,
                          PortletRendererPropertiesEditForm),
                provides=IFormManager)
class NearmeMapSearchResultsPortletRendererSettingsFormManager(DialogEditFormFormManager):
    """Near-me search results portlet map renderer settings properties edit form manager"""

    def getFields(self):
        fields = Fields(INearmeMapSearchResultsPortletRendererSettings).omit(
            'use_default_map_configuration')
        fields['no_use_default_map_configuration'].widgetFactory = SingleCheckBoxFieldWidget
        return fields

    def updateGroups(self):
        form = self.view
        form.add_group(NamedWidgetsGroup(form, 'configuration', form.widgets,
                                         ('no_use_default_map_configuration', ) + tuple([
                                             name
                                             for name, field in getFieldsInOrder(IMapConfiguration)
                                         ]),
                                         legend=_("Don't use default map configuration"),
                                         css_class='inner',
                                         switch=True,
                                         checkbox_switch=True,
                                         checkbox_field=INearmeMapSearchResultsPortletRendererSettings[
                                             'no_use_default_map_configuration']))
        super().updateGroups()
