#
# Copyright (c) 2015-2023 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from zope.container.constraints import contains
from zope.interface import Attribute
from zope.schema import Bool, Int

from onf_website.features.search.skin.interfaces import IMapSearchResultsPortletRendererSettings
from onf_website.features.search.skin.interfaces.filter import IFilter, IFilterContainer, IFilterContainerTarget, \
    ISearchResultsPortletAdvancedFiltersRendererSettings
from pyams_i18n.schema import I18nTextField, I18nTextLineField

from onf_website import _


NEARME_FILTER_CONTAINER_ANNOTATION_KEY = 'onf_website.search.filters.nearme'


class INearmeFilter(IFilter):
    """Near-me filter interface"""
    
    
class INearmeFilterContainer(IFilterContainer):
    """Near-me filter container interface"""

    contains(INearmeFilter)


class INearmeFilterContainerTarget(IFilterContainerTarget):
    """Near-me filter container target marker interface"""


class INearmeSearchResultsPortletRendererSettings(ISearchResultsPortletAdvancedFiltersRendererSettings):
    """Near-me advanced filters search results portlet renderer settings"""

    display_results_count = Attribute("Removed attribute (display_results_count)")
    allow_sorting = Attribute("Removed attribute (allow_sorting)")
    allow_pagination = Attribute("Removed attribute (allow_pagination")
    header_display_mode = Attribute("Removed attribute (header_display_mode)")
    start_length = Attribute("Removed attribute (start_length)")

    description = I18nTextField(title=_("Search description"),
                                required=False)
    
    dropdown_menu_title = I18nTextLineField(title=_("Dropdown menu title"),
                                            description=_("Label positioned above the dropdown menu"),
                                            required=False)

    map_mode_label = I18nTextLineField(title=_("Map mode label"),
                                      description=_("Label used for map mode"),
                                      required=False)

    list_mode_label = I18nTextLineField(title=_("List mode label"),
                                        description=_("Label used for list mode"),
                                        required=False)

    empty_results_title = I18nTextLineField(title=_("Empty results title"),
                                            description=_("Information title displayed when no results are found"),
                                            required=False)

    empty_results_message = I18nTextField(title=_("Empty results message"),
                                          description=_("Information message displayed when no results are found"),
                                          required=False)

    help_title = I18nTextLineField(title=_("Help title"),
                                   description=_("Help title displayed above the search map"),
                                   required=False)

    help_message = I18nTextField(title=_("Help message"),
                                 description=_("Help message displayed above the search map"),
                                 required=False)

    open_links_in_new_tabs = Bool(title=_("Open links in new tabs"),
                                  description=_("If 'yes', results links will be displayed in new tabs instead "
                                                "of the current one"),
                                  required=True,
                                  default=True)

    filters = Attribute("Search filters")


class INearmeMapSearchResultsPortletRendererSettings(INearmeSearchResultsPortletRendererSettings,
        IMapSearchResultsPortletRendererSettings):
    """Near-me search results portlet map renderer with head filters settings """

    map_height = Attribute("Removed attribute (map_height)")

    map_distance = Int(title=_("Map search distance"),
                       description=_("Maximum search distance (given in km) from location center"),
                       required=True,
                       default=50)
