#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from persistent import Persistent
from zope.interface import Interface
from zope.location import Location
from zope.schema.fieldproperty import FieldProperty

from onf_website.features.menu.skin.interfaces import IONFDoubleNavigationWithBackgroundPortletRendererSettings
from pyams_content.component.association.interfaces import IAssociationInfo
from pyams_content.features.menu.portlet.navigation.interfaces.double import IDoubleNavigationPortletSettings
from pyams_file.property import FileProperty
from pyams_portal.interfaces import IPortalContext, IPortletRenderer
from pyams_portal.portlet import PortletRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.factory import factory_config

from onf_website import _


#
# Double navigation portlet "double-select" renderer
#

@factory_config(provided=IONFDoubleNavigationWithBackgroundPortletRendererSettings)
class ONFDoubleNavigationWithbackgroundPortletRendererSettings(Persistent, Location):
    """ONF double navigation with background portlet renderer settings"""

    subtitle = FieldProperty(IONFDoubleNavigationWithBackgroundPortletRendererSettings['subtitle'])
    background = FileProperty(IONFDoubleNavigationWithBackgroundPortletRendererSettings['background'])


@adapter_config(name='double-navigation',
                context=(IPortalContext, IPyAMSLayer, Interface, IDoubleNavigationPortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/navigation-double.pt', layer=IPyAMSLayer)
class ONFDoubleNavigationWithBackgroundPortletRenderer(PortletRenderer):
    """Double navigation with background portlet menus renderer"""

    label = _("ONF: Double navigation with background")

    settings_interface = IONFDoubleNavigationWithBackgroundPortletRendererSettings

    @staticmethod
    def get_link_info(link):
        return IAssociationInfo(link)
