#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from onf_website.features.footer import DefaultFooterRendererSettings, \
    IONFFooterV2RendererSettings, ONFFooterV2RendererSettings
from onf_website.features.footer.interfaces import IDefaultFooterRendererSettings
from pyams_content.component.association.interfaces import IAssociationInfo
from pyams_content.features.footer.interfaces import IFooterRenderer, IFooterRendererSettings, \
    IFooterSettings, IFooterTarget
from pyams_default_theme.features.footer.skin import BaseFooterRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config

__docformat__ = 'restructuredtext'

from onf_website import _


#
# Default footer renderer
#

DEFAULT_FOOTER_RENDERER_NAME = 'ONF default footer'


@adapter_config(name=DEFAULT_FOOTER_RENDERER_NAME, context=(IFooterTarget, IPyAMSLayer),
                provides=IFooterRenderer)
@adapter_config(name=DEFAULT_FOOTER_RENDERER_NAME, context=(IFooterSettings, IPyAMSLayer),
                provides=IFooterRenderer)
@template_config(template='templates/default-footer.pt', layer=IPyAMSLayer)
class ONFDefaultFooterRenderer(BaseFooterRenderer):
    """ONF default footer renderer"""

    name = DEFAULT_FOOTER_RENDERER_NAME
    label = _("ONF default footer")
    weight = 10

    settings_key = 'ONF::default'
    settings_interface = IDefaultFooterRendererSettings

    @staticmethod
    def get_link_info(link):
        return IAssociationInfo(link)


@adapter_config(context=ONFDefaultFooterRenderer, provides=IFooterRendererSettings)
def default_footer_renderer_settings_factory(context):
    """Default footer renderer settings factory"""
    return DefaultFooterRendererSettings()


#
# ONF footer renderer v2
#

FOOTER_V2_RENDERER_NAME = 'ONF-footer-v2'


@adapter_config(name=FOOTER_V2_RENDERER_NAME,
                context=(IFooterTarget, IPyAMSLayer),
                provides=IFooterRenderer)
@adapter_config(name=FOOTER_V2_RENDERER_NAME,
                context=(IFooterSettings, IPyAMSLayer),
                provides=IFooterRenderer)
@template_config(template='templates/footer-v2.pt', layer=IPyAMSLayer)
class ONFFooterV2Renderer(BaseFooterRenderer):
    """ONF footer v2 renderer"""

    name = FOOTER_V2_RENDERER_NAME
    label = _("ONF footer v2")
    weight = 20

    settings_key = 'ONF::v2'
    settings_interface = IONFFooterV2RendererSettings

    @staticmethod
    def get_link_info(link):
        return IAssociationInfo(link)


@adapter_config(context=ONFFooterV2Renderer,
                provides=IFooterRendererSettings)
def footer_v2_renderer_settings_factory(context):
    """ONF footer v2 renderer settings factory"""
    return ONFFooterV2RendererSettings()
