# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from z3c.form.field import Fields
from zope.component.interfaces import ISite

from onf_website.features.firebase.interfaces import IFirebaseSubscriptionsCheckerTask, \
    IFirebaseSubscriptionsCheckerTaskInfo
from onf_website.features.firebase.task import FirebaseSubscriptionsCheckerTask
from pyams_form.form import AJAXAddForm, ajax_config
from pyams_pagelet.pagelet import pagelet_config
from pyams_scheduler.zmi.scheduler import SchedulerTasksTable
from pyams_scheduler.zmi.task import TaskBaseAddForm
from pyams_skin.interfaces.viewlet import IToolbarAddingMenu
from pyams_skin.layer import IPyAMSLayer
from pyams_skin.viewlet.toolbar import ToolbarMenuItem
from pyams_utils.interfaces import MANAGE_SYSTEM_PERMISSION
from pyams_viewlet.viewlet import viewlet_config

__docformat__ = 'restructuredtext'

from onf_website import _
from pyams_zmi.form import AdminDialogEditForm


@viewlet_config(name='add-subscriptions-checker-task.menu', context=ISite, layer=IPyAMSLayer,
                view=SchedulerTasksTable, manager=IToolbarAddingMenu,
                permission=MANAGE_SYSTEM_PERMISSION, weight=115)
class FirebaseSubscriptionsCheckerTaskAddMenu(ToolbarMenuItem):
    """Firebase subscriptions checker task add menu"""

    label = _("Add subscriptions checker task...")
    label_css_class = 'fa fa-fw fa-notify'
    url = 'add-subscriptions-checker-task.html'
    modal_target = True


@pagelet_config(name='add-subscriptions-checker-task.html', context=ISite, layer=IPyAMSLayer,
                permission=MANAGE_SYSTEM_PERMISSION)
@ajax_config(name='add-subscriptions-checker-task.json', context=ISite, layer=IPyAMSLayer,
             permission=MANAGE_SYSTEM_PERMISSION, base=AJAXAddForm)
class FirebaseSubscriptionsCheckerTaskAddForm(TaskBaseAddForm):
    """Firebase subscriptions checker task add form"""

    legend = _("Add subscriptions checker")
    icon_css_class = 'fa fa-fw fa-notify'

    task_factory = FirebaseSubscriptionsCheckerTask


@pagelet_config(name='settings.html',
                context=IFirebaseSubscriptionsCheckerTask, layer=IPyAMSLayer,
                permission=MANAGE_SYSTEM_PERMISSION)
@ajax_config(name='settings.json',
             context=IFirebaseSubscriptionsCheckerTask, layer=IPyAMSLayer,
             permission=MANAGE_SYSTEM_PERMISSION)
class FirebaseSubscriptionsCheckerTaskEditForm(AdminDialogEditForm):
    """Firebase subscriptions checker task edit form"""
    
    prefix = 'subscriptions_settings.'
    
    @property
    def title(self):
        translate = self.request.localizer.translate
        return translate(_("Scheduler task: {0}")).format(self.context.name)
    
    legend = _("Edit task settings")
    icon_css_class = 'fa fa-fw fa-notify'
    
    fields = Fields(IFirebaseSubscriptionsCheckerTaskInfo)
    edit_permission = MANAGE_SYSTEM_PERMISSION
