#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface

from onf_website.skin.public import aside_sticky, aside_toc
from onf_website.skin.public.layer import IONFBaseLayer
from pyams_content.component.paragraph.portlet import ParagraphContainerPortlet
from pyams_content.component.paragraph.portlet.interfaces import IParagraphNavigationPortletSettings
from pyams_default_theme.component.paragraph.portlet import ParagraphNavigationPortletRenderer
from pyams_portal.interfaces import IPortalContext, IPortletCSSClass, IPortletRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config


@adapter_config(context=(ParagraphContainerPortlet, IONFBaseLayer), provides=IPortletCSSClass)
def navigator_portlet_class_adapter(context, request):
    return 'sticky-playground'


@adapter_config(context=(IPortalContext, IPyAMSLayer, Interface, IParagraphNavigationPortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/navigation-default.pt', layer=IONFBaseLayer)
class DefaultParagraphNavigationPortletRenderer(ParagraphNavigationPortletRenderer):
    """Default ONF paragraph navigation portlet renderer"""

    resources = (aside_sticky, aside_toc)
