#
# Copyright (c) 2008-2017 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.component.paragraph.interfaces.keypoint import IKeypointsParagraph
from pyams_content.features.renderer.interfaces import IContentRenderer
from pyams_skin.layer import IPyAMSLayer

# import packages
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_default_theme.component.paragraph.keypoint \
    import KeypointsParagraphDefaultRenderer as BaseKeypointsParagraphRenderer

from onf_website import _


#
# Key points paragraph default renderer
#

@adapter_config(name='default', context=(IKeypointsParagraph, IPyAMSLayer), provides=IContentRenderer)
@template_config(template='templates/keypoints-default.pt', layer=IPyAMSLayer)
class KeypointsParagraphDefaultRenderer(BaseKeypointsParagraphRenderer):
    """Key points paragraph default renderer"""

    label = _("ONF default key points renderer")


@adapter_config(name='number', context=(IKeypointsParagraph, IPyAMSLayer), provides=IContentRenderer)
@template_config(template='templates/keypoints-number.pt', layer=IPyAMSLayer)
class KeypointsNumberedParagraphRenderer(BaseKeypointsParagraphRenderer):
    """Key points paragraph numbered renderer"""

    label = _("ONF numbered key points renderer")
