#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from onf_website.reference.insee.schema import CommuneField
from pyams_content.component.paragraph.interfaces.contact import IContactParagraph as IBaseContactParagraph

from onf_website import _


class IContactParagraph(IBaseContactParagraph):
    """Contact paragraph interface"""

    city = CommuneField(title=_("City"),
                        description=_("If you can't set GPS coordinates, location map will be "
                                      "centered on this city without location mark"),
                        required=False)
