#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#


__docformat__ = 'restructuredtext'

try:
    from pyams_gis.schema import GeoPointField
except ImportError:
    GeoPointField = None
    have_gis = False
else:
    have_gis = True

from zope.schema import TextLine, Choice

from pyams_content.component.paragraph import IBaseParagraph
from pyams_content.shared.logo import WfLogo
from pyams_file.schema import ImageField
from pyams_i18n.schema import I18nTextLineField, I18nTextField
from pyams_sequence.schema import InternalReferenceField

from onf_website import _


CLIENT_PARAGRAPH_TYPE = 'Client'
CLIENT_PARAGRAPH_NAME = _("Client card")
CLIENT_PARAGRAPH_RENDERERS = 'PyAMS.paragraph.client.renderers'


class IClientParagraph(IBaseParagraph):
    """Contact paragraph interface"""

    title = I18nTextLineField(title=_("§ Title"),
                              required=False)

    text_1 = I18nTextField(title=_("Text §1"),
                           description=_("Description of the company needs"),
                           required=False)

    title_2 = I18nTextLineField(title=_("Title §2"),
                                description=_("Goal of the intervention"),
                                required=False)

    text_2 = I18nTextField(title=_("Text §2"),
                           description=_("Explanations of the intervention"),
                           required=False)

    logo = InternalReferenceField(title=_("Logo"),
                                  description=_("Logo of client company"),
                                  content_type=WfLogo.content_type,
                                  required=False)

    def get_logo(self):
        """Get reference to selected logo"""

    name = TextLine(title=_("Contact identity"),
                    description=_("Name of the contact"),
                    required=False)

    charge = I18nTextLineField(title=_("In charge of"),
                               description=_("Label of contact function"),
                               required=False)

    photo = ImageField(title=_("Photo"),
                       description=_("Use 'browse' button to select contact picture"),
                       required=False)

    quote = I18nTextField(title=_("Quoted text"),
                          description=_("Quotation marks will be added automatically by presentation template"),
                          required=False)

    if have_gis:
        gps_location = GeoPointField(title=_("GPS location"),
                                     description=_("GPS coordinates used to locate the project"),
                                     required=False)

    project_start = I18nTextLineField(title=_("Project start"),
                                      description=_("Start period of the project"),
                                      required=False)

    project_end = I18nTextLineField(title=_("Project end"),
                                    description=_("End period of the project"),
                                    required=False)

    renderer = Choice(title=_("Client template"),
                      description=_("Presentation template used for this client"),
                      vocabulary=CLIENT_PARAGRAPH_RENDERERS,
                      default='default')
