#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import implementer
from zope.schema.fieldproperty import FieldProperty

from onf_website.component.location.interfaces import ILocationTarget
from onf_website.component.paragraph.interfaces.contact import IContactParagraph
from pyams_content.component.paragraph import BaseParagraphFactory
from pyams_content.component.paragraph.contact import ContactParagraph as BaseContactParagraph, \
    JSONContactParagraphConverter as JSONContactParagraphConverterBase
from pyams_content.component.paragraph.interfaces import IParagraphFactory
from pyams_content.component.paragraph.interfaces.contact import CONTACT_PARAGRAPH_TYPE
from pyams_content.features.json import IJSONConverter
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import adapter_config
from pyams_utils.factory import factory_config
from pyams_utils.registry import utility_config

__docformat__ = 'restructuredtext'

from onf_website import _


@factory_config(IContactParagraph)
@implementer(ILocationTarget)
class ContactParagraph(BaseContactParagraph):
    """Contact paragraph"""

    city = FieldProperty(IContactParagraph['city'])


@utility_config(name=CONTACT_PARAGRAPH_TYPE, provides=IParagraphFactory)
class ContactParagraphFactory(BaseParagraphFactory):
    """Contact paragraph factory"""

    name = _("Identity card")
    content_type = ContactParagraph
    secondary_menu = True


@adapter_config(required=(IContactParagraph, IPyAMSLayer),
                provides=IJSONConverter)
class JSONContactParagraphConverter(JSONContactParagraphConverterBase):
    """JSON contact paragraph converter"""

    excluded_converters = ('location',)

    def convert_content(self, params):
        result = super().convert_content(params)
        self.get_attribute(self.context, 'city', result, 'insee_code')
        return result
