#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

# import standard library
from persistent import Persistent
from persistent.mapping import PersistentMapping

# import interfaces
from onf_website.component.location.interfaces import LOCATION_SETTINGS_KEY, LOCATION_SETTINGS_KEYS, ILocationSetting, \
    ILocationManagerSettings, ILocationManagerTarget

# import packages
from pyams_utils.adapter import adapter_config, get_annotation_adapter
from zope.interface import implementer
from zope.schema.fieldproperty import FieldProperty


@implementer(ILocationSetting)
class LocationSetting(object):
    """Location component setting"""

    visible = FieldProperty(ILocationSetting['visible'])
    unfolded = FieldProperty(ILocationSetting['unfolded'])

    def __init__(self, name):
        self.name = name


@implementer(ILocationManagerSettings)
class LocationManagerSettings(Persistent):
    """Location manager settings"""

    settings = FieldProperty(ILocationManagerSettings['settings'])

    def __init__(self):
        self.settings = PersistentMapping()

    def get(self, key, default=None):
        return self.settings.get(key, default)

    def __setitem__(self, key, value):
        self.settings[key] = value

    def __getitem__(self, key):
        return self.settings[key]


@adapter_config(context=ILocationManagerTarget, provides=ILocationManagerSettings)
def location_manager_settings_factory(context):
    """Location manager target settings factory"""

    def settings_factory():
        settings = LocationManagerSettings()
        for key in LOCATION_SETTINGS_KEYS:
            settings[key] = LocationSetting(key)
        return settings

    return get_annotation_adapter(context, LOCATION_SETTINGS_KEY, factory=settings_factory)
