#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from z3c.form import field
from z3c.form.browser.checkbox import SingleCheckBoxFieldWidget

from onf_website.component.illustration.interfaces import IIllustrationParagraphRendererSettings
from pyams_content.features.renderer.zmi import RendererPropertiesEditForm
from pyams_form.group import NamedWidgetsGroup
from pyams_form.interfaces.form import IFormManager
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import ContextRequestViewAdapter, adapter_config
from pyams_zmi.form import AdminDialogEditForm

from onf_website import _


@adapter_config(context=(IIllustrationParagraphRendererSettings, IPyAMSLayer, RendererPropertiesEditForm),
                provides=IFormManager)
class IllustrationParagraphDefaultRendererSettingsFormManager(ContextRequestViewAdapter):
    """Illustration paragraph default renderer settings form manager"""

    def getFields(self):
        fields = field.Fields(IIllustrationParagraphRendererSettings)
        fields['display_description'].widgetFactory = SingleCheckBoxFieldWidget
        return fields

    def update(self):
        form = self.view
        form.dialog_class = 'modal-large'
        AdminDialogEditForm.update(form)

    def updateWidgets(self, prefix=None):
        AdminDialogEditForm.updateWidgets(self.view, prefix)

    def updateActions(self):
        AdminDialogEditForm.updateActions(self.view)

    def updateGroups(self):
        form = self.view
        form.add_group(NamedWidgetsGroup(form, 'description', form.widgets,
                                         form.fields.keys(),
                                         legend=_("Display associated text"),
                                         css_class='inner',
                                         switch=True,
                                         checkbox_switch=True,
                                         checkbox_field=IIllustrationParagraphRendererSettings['display_description']))
        AdminDialogEditForm.updateGroups(form)
