#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from z3c.form import button, field
from z3c.form.browser.checkbox import CheckBoxFieldWidget
from z3c.form.interfaces import INPUT_MODE
from zope.interface import Interface, implementer

from onf_website.component.hearing.interfaces import HEARING_SETTINGS, IViewHearingSettings
from pyams_content.interfaces import MANAGE_CONTENT_PERMISSION
from pyams_content.shared.common.zmi import WfSharedContentHeaderAdapter
from pyams_content.shared.view.interfaces import IWfView
from pyams_form.form import ajax_config
from pyams_form.interfaces.form import IInnerSubForm, IUncheckedEditFormButtons, IWidgetForm
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.interfaces import IInnerPage, IPageHeader
from pyams_skin.layer import IPyAMSLayer
from pyams_skin.viewlet.menu import MenuItem
from pyams_utils.adapter import adapter_config
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION
from pyams_viewlet.viewlet import viewlet_config
from pyams_zmi.form import AdminEditForm, InnerAdminEditForm
from pyams_zmi.interfaces.menu import IPropertiesMenu
from pyams_zmi.layer import IAdminLayer


__docformat__ = 'restructuredtext'

from onf_website import _


@viewlet_config(name='hearing.menu',
                context=IWfView, layer=IAdminLayer,
                manager=IPropertiesMenu, weight=320,
                permission=VIEW_SYSTEM_PERMISSION)
class HearingMenu(MenuItem):
    """Hearing menu"""

    label = _("Hearing...")
    icon_class = 'fa-volume-up'
    url = '#hearing.html'


@pagelet_config(name='hearing.html',
                context=IWfView, layer=IPyAMSLayer,
                permission=VIEW_SYSTEM_PERMISSION)
@ajax_config(name='hearing.json',
             context=IWfView, layer=IPyAMSLayer,
             permission=MANAGE_CONTENT_PERMISSION)
@implementer(IWidgetForm, IInnerPage)
class HearingEditForm(AdminEditForm):
    """hearing settings edit form"""

    prefix = 'view_hearing_form.'

    legend = _("View hearing settings")

    fields = field.Fields(Interface)

    @property
    def buttons(self):
        if self.mode == INPUT_MODE:
            return button.Buttons(IUncheckedEditFormButtons)
        return button.Buttons(Interface)


@adapter_config(name='readership',
                context=(IWfView, IPyAMSLayer, HearingEditForm),
                provides=IInnerSubForm)
class HearingTargetsEditSubform(InnerAdminEditForm):
    """Hearing targets edit form"""

    prefix = 'hearing_readership.'

    legend = None
    main_group_legend = HEARING_SETTINGS['readership']

    fields = field.Fields(IViewHearingSettings).select('select_context_targets', 'targets')
    fields['targets'].widgetFactory = CheckBoxFieldWidget
    weight = 1


@adapter_config(name='national',
                context=(IWfView, IPyAMSLayer, HearingEditForm),
                provides=IInnerSubForm)
class HearingNationalScopeEditSubform(InnerAdminEditForm):
    """Hearing national scope edit form"""

    prefix = 'hearing_national.'

    legend = None
    main_group_legend = HEARING_SETTINGS['national']

    fields = field.Fields(IViewHearingSettings).select('use_context_national_scope',
                                                       'national_scope')
    weight = 2


@adapter_config(name='location',
                context=(IWfView, IPyAMSLayer, HearingEditForm),
                provides=IInnerSubForm)
class HearingLocationEditSubform(InnerAdminEditForm):
    """Hearing location edit form"""

    prefix = 'hearing_location.'

    legend = None
    main_group_legend = HEARING_SETTINGS['location']

    fields = field.Fields(IViewHearingSettings).select('select_context_forests', 'forests',
                                                       'select_context_cities', 'cities',
                                                       'select_context_departments', 'departments',
                                                       'select_context_countries', 'countries',
                                                       'add_national_scope')
    weight = 3


@adapter_config(name='organization',
                context=(IWfView, IPyAMSLayer, HearingEditForm),
                provides=IInnerSubForm)
class HearingOrganizationEditSubform(InnerAdminEditForm):
    """Hearing organization edit form"""

    prefix = 'hearing_organization.'

    legend = None
    main_group_legend = HEARING_SETTINGS['organization']

    fields = field.Fields(IViewHearingSettings).select('select_context_structures', 'structures')
    weight = 4


@adapter_config(name='sites',
                context=(IWfView, IPyAMSLayer, HearingEditForm),
                provides=IInnerSubForm)
class HearingDiffusionSitesEditSubform(InnerAdminEditForm):
    """Hearing diffusion sites edit form"""

    prefix = 'hearing_sites.'

    legend = None
    main_group_legend = HEARING_SETTINGS['sites']

    fields = field.Fields(IViewHearingSettings).select('select_context_sites', 'diffusion_sites')
    weight = 5


@adapter_config(context=(IWfView, IAdminLayer, HearingEditForm),
                provides=IPageHeader)
class HearingHeaderAdapter(WfSharedContentHeaderAdapter):
    """Shared content hearing header adapter"""

    icon_class = 'fa fa-fw fa-volume-up'
