#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from z3c.form import field
from z3c.form.browser.checkbox import CheckBoxFieldWidget

from onf_website import _
from onf_website.component.hearing.interfaces import IViewHearingSettings
from onf_website.component.hearing.zmi.view import HearingDiffusionSitesEditSubform, HearingEditForm, \
    HearingLocationEditSubform, HearingNationalScopeEditSubform, HearingOrganizationEditSubform, \
    HearingTargetsEditSubform
from pyams_content.features.search import ISearchFolder
from pyams_content.interfaces import MANAGE_CONTENT_PERMISSION
from pyams_form.form import ajax_config
from pyams_form.interfaces.form import IInnerSubForm
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import adapter_config
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION


@pagelet_config(name='hearing.html', context=ISearchFolder, layer=IPyAMSLayer, permission=VIEW_SYSTEM_PERMISSION)
@ajax_config(name='hearing.json', context=ISearchFolder, layer=IPyAMSLayer, permission=MANAGE_CONTENT_PERMISSION)
class SearchFolderHearingEditForm(HearingEditForm):
    """Search folder hearing settings edit form"""

    legend = _("Search folder hearing settings")


@adapter_config(name='readership',
                context=(ISearchFolder, IPyAMSLayer, SearchFolderHearingEditForm),
                provides=IInnerSubForm)
class SearchFolderHearingTargetsEditSubform(HearingTargetsEditSubform):
    """Hearing targets edit form"""

    fields = field.Fields(IViewHearingSettings).select('targets')
    fields['targets'].widgetFactory = CheckBoxFieldWidget

    def updateWidgets(self, prefix=None):
        super(SearchFolderHearingTargetsEditSubform, self).updateWidgets(prefix)
        if 'targets' in self.widgets:
            self.widgets['targets'].label = _("Targets")


@adapter_config(name='national',
                context=(ISearchFolder, IPyAMSLayer, SearchFolderHearingEditForm),
                provides=IInnerSubForm)
class SearchFolderHearingNationalScopeEditSubform(HearingNationalScopeEditSubform):
    """Hearing national scope edit form"""

    fields = field.Fields(IViewHearingSettings).select('national_scope')


@adapter_config(name='location',
                context=(ISearchFolder, IPyAMSLayer, SearchFolderHearingEditForm),
                provides=IInnerSubForm)
class SearchFolderHearingLocationEditSubform(HearingLocationEditSubform):
    """Hearing location edit form"""

    fields = field.Fields(IViewHearingSettings).select('forests', 'cities', 'departments', 'countries',
                                                       'add_national_scope')

    def updateWidgets(self, prefix=None):
        super(SearchFolderHearingLocationEditSubform, self).updateWidgets(prefix)
        if 'forests' in self.widgets:
            self.widgets['forests'].label = _("Forests")
        if 'cities' in self.widgets:
            self.widgets['cities'].label = _("Cities")
        if 'departments' in self.widgets:
            self.widgets['departments'].label = _("Departments")
        if 'countries' in self.widgets:
            self.widgets['countries'].label = _("Countries")


@adapter_config(name='organization',
                context=(ISearchFolder, IPyAMSLayer, SearchFolderHearingEditForm),
                provides=IInnerSubForm)
class SearchFolderHearingOrganizationEditSubform(HearingOrganizationEditSubform):
    """Hearing organization edit form"""

    fields = field.Fields(IViewHearingSettings).select('structures')

    def updateWidgets(self, prefix=None):
        super(SearchFolderHearingOrganizationEditSubform, self).updateWidgets(prefix)
        if 'structures' in self.widgets:
            self.widgets['structures'].label = _("Structures")


@adapter_config(name='sites',
                context=(ISearchFolder, IPyAMSLayer, SearchFolderHearingEditForm),
                provides=IInnerSubForm)
class SearchFolderHearingDiffusionSitesEditSubform(HearingDiffusionSitesEditSubform):
    """Hearing diffusion sites edit form"""

    fields = field.Fields(IViewHearingSettings).select('diffusion_sites')

    def updateWidgets(self, prefix=None):
        super(SearchFolderHearingDiffusionSitesEditSubform, self).updateWidgets(prefix)
        if 'diffusion_sites' in self.widgets:
            self.widgets['diffusion_sites'].label = _("Diffusion sites")
