#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from persistent import Persistent
from zope.container.contained import Contained
from zope.interface import Interface
from zope.schema.fieldproperty import FieldProperty

from onf_website.component.gallery.portlet.interfaces import IGalleryPortletMosaicRendererSettings
from onf_website.skin.public import baguettebox, magic_grid
from pyams_content.component.gallery import IBaseGallery
from pyams_content.component.gallery.portlet.interfaces import IGalleryPortletSettings
from pyams_default_theme.component.gallery.portlet import GalleryPortletBaseRenderer
from pyams_portal.interfaces import IPortalContext, IPortletRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config


__docformat__ = 'restructuredtext'

from onf_website import _
from pyams_utils.factory import factory_config


@factory_config(IGalleryPortletMosaicRendererSettings)
class GalleryPortletMosaicRendererSettings(Persistent, Contained):
    """Gallery portlet mosaic renderer settings"""

    thumbnails_count = FieldProperty(IGalleryPortletMosaicRendererSettings['thumbnails_count'])
    button_label = FieldProperty(IGalleryPortletMosaicRendererSettings['button_label'])

    def __init__(self):
        super().__init__()
        self.button_label = {
            'en': "Display all images",
            'fr': "Afficher toutes les images"
        }


@adapter_config(name='mosaic-portlet',
                context=(IPortalContext, IPyAMSLayer, Interface, IGalleryPortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/gallery-mosaic.pt', layer=IPyAMSLayer)
class ONFGalleryPortletMosaicRenderer(GalleryPortletBaseRenderer):
    """Gallery portlet mosaic renderer"""

    label = _("ONF: Images grid")

    settings_interface = IGalleryPortletMosaicRendererSettings

    def get_medias(self):
        gallery = IBaseGallery(self.context, None)
        if gallery is not None:
            yield from gallery.get_visible_medias()

    def get_images(self):
        gallery = IBaseGallery(self.context, None)
        if gallery is not None:
            yield from gallery.get_visible_images()

    resources = (baguettebox, )
