#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.schema import Int

from pyams_i18n.schema import I18nTextField, I18nTextLineField
from pyams_portal.interfaces import IPortletRendererSettings

from onf_website import _


GALLERY_PARAGRAPH_BEFOREAFTER_SETTINGS_KEY = 'pyams_content.gallery.renderer:before-after'


class IGalleryParagraphBeforeAfterRendererSettings(IPortletRendererSettings):
    """Gallery paragraph before/after renderer settings"""

    description = I18nTextField(title=_("Gallery description"),
                                required=False)


GALLERY_PARAGRAPH_MOSAIC_SETTINGS_KEY = 'pyams_content.gallery.renderer:mosaic'


class IGalleryParagraphMosaicRendererSettings(IPortletRendererSettings):
    """Gallery paragraph mosaic renderer settings"""

    thumbnails_count = Int(title=_("Thumbnails count"),
                           description=_("Number of gallery images displayed as thumbnails"),
                           required=True,
                           default=6)

    button_label = I18nTextLineField(title=_("Button label"),
                                     description=_("Label displayed on button used to display "
                                                   "all gallery images"),
                                     required=True)
