#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_form.interfaces import IForm
from pyams_skin.interfaces.tinymce import ITinyMCEConfiguration
from pyams_zmi.layer import IAdminLayer

# import packages
from onf_website.skin.zmi import onf_website
from pyams_content.zmi import pyams_content
from pyams_content.zmi.tinymce import TinyMCEEditorConfiguration as TinyMCEEditorConfigurationBase
from pyams_utils.adapter import adapter_config
from pyams_utils.fanstatic import get_resource_path


@adapter_config(context=(IForm, IAdminLayer), provides=ITinyMCEConfiguration)
class TinyMCEEditorConfiguration(TinyMCEEditorConfigurationBase):
    """Custom TinyMCE editor configuration"""

    @property
    def configuration(self):
        return {
            'ams-plugins': 'pyams_content onf_website',
            'ams-plugin-pyams_content-src': get_resource_path(pyams_content),
            'ams-plugin-pyams_content-async': 'false',
            'ams-plugin-onf_website-src': get_resource_path(onf_website),
            'ams-plugin-onf_website-async': 'false',
            'ams-tinymce-init-callback': 'ONF_website.TinyMCE.initEditor'
        }
